jQuery(function ($) {

    /**
     * @param {string} wpab '0' if sssp is loaded, '1' if sssp is blocked by adblock
     */
    function send_wpstat(wpab) {
        if (!navigator || !navigator.userAgent) {
            return;
        }
        var uaRegexWhitelist = new RegExp(
            'google|seznambot|bingbot|yandexbot|Naverbot|msnbot|' +
            'ia_archiver|baiduspider|applebot|slurp|duckduckbot|' +
            'BUbiNG|BingPreview|seoscanners|VoilaBot|adscanner|' +
            'Qwantify|spider|crawler|slurp|externalhit|ttd-content|' +
            'SznProhlizec|MSIE|Trident|iPhone|HeadlessChrome|https?:[\/][\/]', 'i'
        );
        if (navigator.userAgent.search(uaRegexWhitelist) !== -1) {
            return;
        }
        $.ajax({
            url: 'https://a.iva.seznam.cz/wpstat',
            headers: {'wpab': wpab},
            type: 'GET',
        });
    }

    /**RUN ADS**/
    jQuery(document).ready(function () { //Verify that document is complete
        if (typeof sssp === "undefined") {
            // Adblock has blocked sssp loading
            send_wpstat('1');
            return;
        }
        if (typeof sssp.getAdsByTags === "function" && typeof sssp_get_breakpoint === "function") {
            send_wpstat('0');

            var matched = jQuery();

            if (window.innerWidth <= sssp_get_breakpoint()) { //Check if the windows is lower or equal to breakpoint
                matched.add(jQuery('.sssp-seznam-ad-desktop').remove()); //Remove desktop ADS
            } else {
                matched.add(jQuery('.sssp-seznam-ad-mobile').remove()); //Remove mobile ADS
            }

            // Remove wallpaper right after in-article
            matched.add(jQuery('[data-szn-ssp-ad-type="wallpaper"]+[data-szn-ssp-ad-type="inarticle"]').remove());
            matched.add(jQuery('[data-szn-ssp-ad-type="inarticle"]:has(+[data-szn-ssp-ad-type="wallpaper"])').remove());

            jQuery.when(matched).then(sssp.getAdsByTags());
        } else {
            //Just let now to the console that something is wrong (for debug purposes)
            console.warn('sssp.getAdsByTags() or sssp_get_breakpoint() is not a function!');
        }
    });

    /**ReloadADS Debug Tool**/
    jQuery(document).on("click", '#sssp-reload-ads', function () {
        jQuery('.sssp-posCont').remove();
        sssp.getAdsByTags();
    });

    function getAndIncrementSspPrioritySession(name = "sspOverlayPriorityCounter") {
        const key = name;
        let count = parseInt(sessionStorage.getItem(key));
        if (isNaN(count)) count = 1;
        else count += 1;
        sessionStorage.setItem(key, count);
        return count;
    }

    function resetSessionCount(name = "sspOverlayPriorityCounter") {
        sessionStorage.setItem(name, 1);
    }

    // Jednorázová ochrana proti vícenásobnému volání na stejný overlay
    const _calledOverlays = new WeakSet();

    function callAd($el) {
        const el = $el[0];
        if (!el) return;

        const elementId = $el.attr("id");
        const zoneId    = $el.data("zone-id");
        const width     = $el.data("width");
        const height    = $el.data("height");
        const postId    = $el.data("post-id");

        const sentinel  = document.getElementById('sssp-content-end');

        // Fallback: if the sentinel is missing (for example, on a page without an article), use the bottom edge of the article instead.
        const postElement =
            document.querySelector('#post-' + postId) ||
            document.querySelector('.post-' + postId) ||
            document.querySelector('[data-post-id="' + postId + '"]') ||
            null;

        let adCalled = false;

        function callAdOnce() {
            if (adCalled || _calledOverlays.has(el)) return;
            adCalled = true;
            _calledOverlays.add(el);

            if (!window.sssp || typeof window.sssp.getAds !== 'function') return;

            const options = {
                zoneId: zoneId,
                id: elementId,
                width: width,
                height: height
            };
            window.sssp.getAds([options]);
        }

        if ('IntersectionObserver' in window && (sentinel || postElement)) {
            const target = sentinel || postElement;

            const io = new IntersectionObserver((entries) => {
                for (const entry of entries) {
                    if (entry.isIntersecting) {
                        io.disconnect();
                        callAdOnce();
                        break;
                    }
                }
            }, {
                root: null,
                rootMargin: '100px 0px 0px 0px',
                threshold: 0
            });

            io.observe(target);
        } else {
            function onScroll() {
                const target = sentinel || postElement;
                if (!target) {
                    window.removeEventListener('scroll', onScroll);
                    callAdOnce();
                    return;
                }
                const rect = target.getBoundingClientRect();
                const trigger = rect.top < window.innerHeight + 100;
                if (trigger) {
                    window.removeEventListener('scroll', onScroll);
                    callAdOnce();
                }
            }
            window.addEventListener('scroll', onScroll, { passive: true });
            onScroll();
        }

        setTimeout(callAdOnce, 8000);
    }


    function callSeznamInterstitialAd(div) {
        const elementId = div.attr("id");
        const zoneId = div.data("zone-id");
        const width = div.data("width");
        const height = div.data("height");
        const blacklist = div.data("blacklist");
        const blacklistArray =
            typeof blacklist === 'string' && blacklist.trim() !== ''
                ? blacklist.split(',')
                : (Array.isArray(blacklist) ? blacklist : []);
        const links = document.querySelectorAll('a');

        links.forEach(link => {
            const href = link.getAttribute('href');
            if (!href || href.startsWith('#') || href.startsWith('javascript:')) return;
            link.addEventListener('click', event => {
                event.preventDefault();
                handleCustomLinkClick(href);
            });
        });

        function handleCustomLinkClick(href) {
            const resolvedHref = new URL(href, window.location.origin).toString();

            // Kontrola, zda resolvedHref obsahuje některý z blacklistovaných řetězců
            const isBlacklisted = blacklistArray.some(blacklistedUrl => resolvedHref.includes(blacklistedUrl.trim()));

            if (isBlacklisted) {
                console.warn('Odkaz je na blacklistu, reklama nebude zobrazena:', resolvedHref);
                window.location.href = href;
                return;
            }

            const options = {
                "zoneId": zoneId,
                "id": elementId,
                "width": width,
                "height": height,
                "options": {
                    "landingUrl": href,
                }
            };

            sssp.getAds([options]);
        }
    }



    /**INTERSTITIAL**/
    function checkSeznamInterstitialAd(div) {
        const displaySeznamAds = sssp.displaySeznamAds();
        var newsfeed = jQuery(div).attr('data-newsfeed');
        var frequencyValue = getAndIncrementSspPrioritySession("sspInterstitialFrequencyCounter");

        if (displaySeznamAds === true &&  (newsfeed === "1" || newsfeed === "2")) {
            if (frequencyValue % 2 !== 0) {
                callSeznamInterstitialAd(div);
            }
        } else if(displaySeznamAds === false && (newsfeed === "0" || newsfeed === "2")){
            if (frequencyValue % 2 === 0) {
                callSeznamInterstitialAd(div);
            }
        }
    }

    function ssp_get_overlay_ads(overlay_divs) {
        if (typeof sssp.getAds === "function" && typeof sssp_get_breakpoint === "function") {

            const sessionCount = getAndIncrementSspPrioritySession();

            const allDivs = [];

            jQuery(overlay_divs).each(function () {
                const $el = $(this);
                const format = $el.data("format");
                const priority = parseInt($el.data("priority"));
                const mode = $el.data("mode");
                const nf = $el.data("nf");

                if (!format || format === "MobileInterstitial"){
                    checkSeznamInterstitialAd($el)
                }else {
                    allDivs.push({ el: $el, priority, format, mode, nf });
                }



            });

            function mergeIntersection(userOrderArray, targetPriority) {
                var defaultOrderDirect={};
                if (userOrderArray[0].nf ===1){
                    defaultOrderDirect = {
                        MobilePopup: 1,
                        MobileVignette: 2,
                    };
                }else {
                    defaultOrderDirect = {
                        MobilePopup: 1,
                        MobileVignette: 2,
                        popupMobileSquare: 3
                    };
                }
                if (userOrderArray[0].nf === 0 && targetPriority > 3 && userOrderArray[0].mode === "cyclic"){
                    resetSessionCount();
                    targetPriority = 1; // reset targetPriority to 1 if mode is cyclic and nf is 0
                }

                const userOrder = userOrderArray.reduce((acc, item) => {
                    acc[item.format] = item.priority;
                    return acc;
                }, {});

                // Najdeme formáty, které jsou v defaultOrder i userOrder
                const keys = Object
                    .keys(defaultOrderDirect)
                    .filter(key => key in userOrder);

                // Seřadíme podle priority uživatele a fallbacku
                const sorted = keys
                    .sort((a, b) => {
                        const ua = userOrder[a];
                        const ub = userOrder[b];
                        if (ua !== ub) return ua - ub;
                        return defaultOrderDirect[a] - defaultOrderDirect[b];
                    });

                // Najdeme format podle targetPriority
                const targetFormat = sorted[targetPriority - 1];


                // Najdeme a vrátíme celý objekt z userOrderArray

                if(userOrderArray[0].mode === "progressive" && userOrderArray[0].nf === 0 && !targetFormat){
                    return userOrderArray.find(item => item.format === sorted[sorted.length - 1]);
                }else {
                    if (!targetFormat){
                        return userOrderArray.find(item => item.format === "MobilePopup") || null;
                    }else {
                        return userOrderArray.find(item => item.format === targetFormat) || null;
                    }

                }
            }


            if (allDivs.length > 0) {
                if (window.innerWidth > sssp_get_breakpoint()){
                    callAd(allDivs.find(item => item.format === "DesktopPopup").el);
                }else {
                    const selected = mergeIntersection(allDivs, sessionCount);
                    callAd(selected.el);
                }

            }
        } else {
            console.warn("sssp.getAds() or sssp_get_breakpoint() is not a function!");
        }
    }





    /**POPUP**/
    jQuery(document).ready(function () {
        var overlay_divs = jQuery('div[id^="sezanmOverlay"]')
        var overlay_mobile_formats = ["popupMobileSquare", "MobileVignette", "MobileInterstitial", "MobilePopup"]
        var overlay_desktop_formats = ["DesktopPopup"]
        var is_mobile = window.innerWidth <= sssp_get_breakpoint();


        if (typeof sssp.getAds === "function" && typeof sssp_get_breakpoint === "function") {
            var feed_source = sssp.displaySeznamAds()
            overlay_divs = overlay_divs.filter(function () {
                var format = jQuery(this).attr('data-format');
                if (is_mobile) {
                    return overlay_mobile_formats.includes(format);
                } else {
                    return overlay_desktop_formats.includes(format);
                }
            });

            overlay_divs = overlay_divs.filter(function () {
                var newsfeed = jQuery(this).attr('data-newsfeed');

                if (feed_source === true) {
                    return newsfeed === "1" || newsfeed === "2";
                } else {
                    return newsfeed !== "1";
                }
            });


            ssp_get_overlay_ads(overlay_divs);

        } else {
            //Just let now to the console that something is wrong (for debug purposes)
            console.warn('sssp.getAds() or sssp_get_breakpoint() is not a function!');
        }
    });

    /**
     * This part of code just remove all other sticky widgets if there are any.
     * It must leave only last child. If not the calculations of positions will be mismatched
     * Sticky Widget
     */
    jQuery(document).ready(function () {

        jQuery('.sssp-sticky-box').each(function () {
            if (jQuery(this).is(":last-child")) {

            } else {
                jQuery(this).removeClass('sssp-sticky-box');
                jQuery('[id="sssp-breakpoint"]:not(#sssp-breakpoint:last)').remove();
            }
        }).promise().done(function () {
            var sticky_box = jQuery('.sssp-sticky-box');
            var sticky_box_id = jQuery('.sssp-sticky-box').attr('id');
            if (sticky_box.length) {
                sssp_sticky('sssp-breakpoint', sticky_box_id);
            }

        });

    });

    /**
     * @param breakPoint
     * @param onScrollElementId
     */
    function sssp_sticky(breakPoint, onScrollElementId) {
        if (window.innerWidth >= 1365) {

            //start time
            var sticky_start_time = jQuery.now();

            //Basic variables before start
            var scrolling_element = jQuery('#' + onScrollElementId + ':last-child'); //On Scroll Widget
            var desktop_class = scrolling_element.hasClass('sssp-seznam-ad-desktop'); //Verify that ad is for a desktop

            var breakpoint_offset = jQuery('#' + breakPoint).offset(); //Breakpoint offset

            if (scrolling_element && desktop_class) {

                //Scrolling element info
                var scrolling_element_width = scrolling_element.outerWidth();
                var scrolling_element_height = scrolling_element.outerHeight();
                var scrolling_element_offset = scrolling_element.offset();

                //Last element info
                var last_element_id = sssp_get_the_last_element_id();
                var last_element_height = jQuery('#' + last_element_id).outerHeight(); //comments section height
                var last_element_offset = jQuery('#' + last_element_id).offset(); //Offset of the div on the end of content

                //Add scrolling element basic CSS
                scrolling_element.css({'width': scrolling_element_width, 'box-sizing': 'border-box', 'position': 'static'});

                if (last_element_id && last_element_offset.top + last_element_height > scrolling_element_offset.top + scrolling_element_height) { //Verify that scrolling is even possible before make you element sticky

                    var widget_id = scrolling_element.find('.sssp-seznam-ad-desktop').data('ssp-ad-id');
                    var sssp_flag_one = true;
                    var sssp_flag_two = false;
                    var sssp_flag_three = false;

                    //Scrolling element offset
                    var left_element_postition = breakpoint_offset.left; //Return ofsset.left value. Reason: If parent element is in Relative position it return wrong left position. So keep it in variable.


                    jQuery(window).scroll(function () {

                        var sticky_current_time = jQuery.now();
                        var breakpoint_offset = jQuery('#' + breakPoint).offset(); //Breakpoint offset
                        var window_top = jQuery(window).scrollTop();
                        var last_element_offset = jQuery('#' + last_element_id).offset(); //Offset of the div on the end of content
                        var offset = 15;
                        var scrolling_element_height = scrolling_element.outerHeight()+offset; //Scrolling element height
                        var last_element_height = jQuery('#' + last_element_id).outerHeight(); //comments section height

                        var top_scroll_offset = jQuery('#' + last_element_id).offset().top - scrolling_element_height + last_element_height - window_top;


                        //Set the end of the element for sticky position
                        var end_offset_status = window_top >= last_element_offset.top - scrolling_element_height - offset + last_element_height;

                        //Just set basic non-sticky statement
                        var ssspsticky = false;

                        //Set basic left offset. It is important for the right position sticky element
                        scrolling_element.css({'left': scrolling_element_offset.left, 'position': 'fixed'});

                        console.log();

                        //This part is responsible for hiding the Sticky widget. It is actually not remove stickyness, just set visibility to hidden.
                        if (scrolling_element_offset && last_element_offset) { //Verify that both parameters are on the page before you start make sticky

                            if (breakpoint_offset.top < window_top && last_element_offset.top > scrolling_element_offset.top) {

                                ssspsticky = true;
                                if (end_offset_status) { //IF Element reach the end
                                    scrolling_element.removeClass('sssp-sticky');
                                    scrolling_element.css({'top': top_scroll_offset, 'left': + left_element_postition});
                                    ssspsticky = false;
                                } else {
                                    scrolling_element.addClass('sssp-sticky');
                                    scrolling_element.css({'top': '', 'left': + left_element_postition});
                                    ssspsticky = true;
                                }
                            }else {
                                //IF Element reach the end
                                scrolling_element.removeClass('sssp-sticky').css({'position': 'static'});
                                scrolling_element.css({'top': '', 'left': + left_element_postition});
                                ssspsticky = false;
                            }
                        }

                        //Remove sticky if is resized window
                        jQuery(window).resize(function () {
                            if (ssspsticky === true) {
                                scrolling_element.removeClass('sssp-sticky').css({'position': 'static', 'left': ''});
                                left_element_postition = jQuery('#' + breakPoint).offset().left; // Return ofsset.left value if windows is resized. Reason: If parent element is in Relative position it return wrong numbers.
                            }
                        });

                        //This part is only or refreshing the ads after 6000 ms and 3000pixels
                        //Refresh the ads
                        if (ssspsticky === true && !end_offset_status && (sssp_flag_one === true || sssp_flag_two === true || sssp_flag_three === true)) {
                            var widget_object = scrolling_element.find('.sssp-seznam-ad-desktop').data('ssp-ad-object');
                            var adOffset = jQuery('#' + widget_id).outerHeight();

                            //Variables for refresh
                            var sssp_max_document_height = 3000;
                            var sssp_time_delay = 6000;

                            var sssp_widget_element = jQuery('#' + widget_id);
                            var sssp_widget_offset = sssp_widget_element.offset().top;

                            if (sssp_widget_offset > sssp_max_document_height - adOffset &&
                                sticky_start_time + sssp_time_delay < sticky_current_time &&
                                sssp_flag_one === true) {
                                jQuery.when(sssp_widget_element.removeAttr('style').find('.sssp-posCont').remove()).then(sssp.getAds(widget_object));
                                sssp_flag_one = false;
                                sssp_flag_two = true;
                                sticky_start_time = jQuery.now();
                            } else if (
                                sssp_widget_offset > sssp_max_document_height * 2 - adOffset &&
                                sticky_start_time + sssp_time_delay + sssp_time_delay < sticky_current_time &&
                                sssp_flag_two === true &&
                                sssp_flag_one === false) {
                                jQuery.when(sssp_widget_element.removeAttr('style').find('.sssp-posCont').remove()).then(sssp.getAds(widget_object));
                                sssp_flag_two = false;
                                sssp_flag_three = true;
                                sticky_start_time = jQuery.now();
                            } else if (
                                sssp_widget_offset > sssp_max_document_height * 3 - adOffset &&
                                sticky_start_time + sssp_time_delay + sssp_time_delay < sticky_current_time &&
                                sssp_flag_three === true &&
                                sssp_flag_two === false) {
                                jQuery.when(sssp_widget_element.removeAttr('style').find('.sssp-posCont').remove()).then(sssp.getAds(widget_object));
                                sssp_flag_three = false;
                                sticky_start_time = jQuery.now();
                            }
                        }

                    });
                }
            }

            /**
             * Last element ID
             * @returns {string|boolean}
             */
            function sssp_get_the_last_element_id() {
                if (jQuery('#sssp-sticky-end').length > 0) { //<div id="sssp-sticky-end"></div>
                    return ('sssp-sticky-end');
                } else {
                    if (jQuery('#comments').length > 0) {
                        return ('comments');
                    } else if (jQuery('#sdop-below-article-box').length > 0) {
                        return ('sdop-below-article-box');
                    } else if (jQuery('#sssp-content-end').length > 0) {
                        return ('sssp-content-end');
                    }else{
                        return false;
                    }
                }
            }
        }
    }

});
