<?php

if (!defined('WPINC')) {
    wp_die();
}

class SSSP_AutomaticInsert
{
    protected static $instance = NULL;

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    public function __construct()
    {
        //Actions
        add_action('get_footer', [$this, 'ads_to_footer']);
        add_action('wp_body_open', [$this, 'ads_to_header']);
        add_action('wp_body_open', [$this, 'ads_to_header_with_branding']);

        // Přesouváme overlay z the_content na konec stránky:
        add_action('wp_footer', [$this, 'print_overlay_divs'], 999);

        //Filters
        add_filter('the_content', [$this, 'prefix_insert_post_ads'], 8);
        add_filter('the_content', [$this, 'ads_below_article'], 9);

        // PŮVODNÍ: add_filter('the_content', [$this, 'add_overlay_div'], 10);
        // Odebráno, protože overlay patří před </body>.
    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     * @since     1.0.0
     *
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (NULL == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     *
     */
    public function ads_to_footer()
    {
        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_key' => 'sssp-zone-position',
            'meta_value' => 'footer',
            'meta_query' => [
                'relation' => 'AND',
                [
                    'relation' => 'OR',
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'active',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'indev',
                        'compare' => '=',
                    ],
                ],
                [
                    'key' => 'sssp-zone-insert',
                    'value' => 'automatic',
                ],
            ],
        ];
        echo self::render_ads($args);
    }

    /**
     *
     */
    public function ads_to_header()
    {
        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_key' => 'sssp-zone-position',
            'meta_value' => 'header',
            'meta_query' => [
                'relation' => 'AND',
                [
                    'relation' => 'OR',
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'active',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'indev',
                        'compare' => '=',
                    ],
                ],
                [
                    'key' => 'sssp-zone-insert',
                    'value' => 'automatic',
                ],
            ],
        ];
        echo self::render_ads($args);
    }

    /**
     *
     */
    public function ads_to_header_with_branding()
    {
        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => 1,
            'post_status' => 'publish',
            'meta_key' => 'sssp-zone-position',
            'meta_value' => 'headerb',
            'meta_query' => [
                'relation' => 'AND',
                [
                    'relation' => 'OR',
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'active',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'indev',
                        'compare' => '=',
                    ],
                ],
                [
                    'key' => 'sssp-zone-insert',
                    'value' => 'automatic',
                ],
            ],
        ];
        echo self::render_ads($args);
    }

    /**
     * @param $content
     * @return string
     */
    public function ads_below_article($content)
    {
        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_key' => 'sssp-zone-position',
            'meta_value' => 'below_a',
            'meta_query' => [
                'relation' => 'AND',
                [
                    'relation' => 'OR',
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'active',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'indev',
                        'compare' => '=',
                    ],
                ],
                [
                    'key' => 'sssp-zone-insert',
                    'value' => 'automatic',
                ],
            ],
        ];
        $ads = self::render_ads($args);

        $sticky_end = '<div id="sssp-content-end"></div>';

        return $content . $ads . $sticky_end;
    }

    /**
     * Nová verze: vloží overlay divy těsně před </body> (wp_footer).
     */
    public function print_overlay_divs()
    {
        if (is_admin() || is_feed()) {
            return;
        }

        $sssp_newsfeed = SSSP_Main::check_ssp_newsfeed();

        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_query' => [
                'relation' => 'AND',
                [
                    'key' => 'sssp-zone-position',
                    'value' => ["popupMobileSquare", "MobileVignette", "MobileInterstitial", "DesktopPopup", "MobilePopup"],
                    'compare' => 'IN',
                ],
                [
                    'relation' => 'OR',
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'active',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'sssp-ad-active',
                        'value' => 'indev',
                        'compare' => '=',
                    ],
                ],
                [
                    'key' => 'sssp-zone-insert',
                    'value' => 'automatic',
                ],
            ],
        ];

        $overlays = get_posts($args);
        if (!$overlays) {
            return;
        }

        $current_post_id = get_queried_object_id();
        $html = '';

        foreach ($overlays as $overlay) {
            $ad_meta = SSSP_Main::get_ad_meta($overlay->ID);

            if (
                $sssp_newsfeed == 1
                && intval($ad_meta['sssp-ad-newsfeed']) === 0
                && $ad_meta['sssp-ad-active'] !== 'active'
            ) {
                continue; // Skip ads that are not for newsfeed and are not active
            }

            $blacklist_attr = '';
            if (!empty($ad_meta['sssp-zone-position']) && $ad_meta['sssp-zone-position'] === 'MobileInterstitial') {
                $blacklist_attr = ' data-blacklist="' . esc_attr(get_option('sssp-url-blacklist')) . '"';
            }

            $zone_id   = isset($ad_meta['sssp-zone-id']) ? $ad_meta['sssp-zone-id'] : '';
            $mode      = get_option('sssp-overlay-mode');
            $breakpt   = get_option('sssp-mobile-breakpoint', '700');

            $html .= '
<style>
    #sezanmOverlay-' . esc_attr($zone_id) . ' * { background-image: unset !important; }
</style>
<div id="sezanmOverlay-' . esc_attr($zone_id) . '"
    data-breakpoint="' . esc_attr($breakpt) . '"
    data-mode="' . esc_attr($mode) . '"
    data-nf="' . esc_attr($sssp_newsfeed) . '"
    data-priority="' . esc_attr($ad_meta['sssp-ad-overlay-priority']) . '"
    data-format="' . esc_attr($ad_meta['sssp-zone-position']) . '"
    data-width="' . esc_attr($ad_meta['sssp-zone-width']) . '"
    data-height="' . esc_attr($ad_meta['sssp-zone-height']) . '"
    data-zone-id="' . esc_attr($zone_id) . '"
    data-newsfeed="' . esc_attr($ad_meta['sssp-ad-newsfeed']) . '"
    data-post-id="' . esc_attr($current_post_id) . '"' .
                $blacklist_attr . '>
</div>';
        }

        echo $html;
    }

    /**
     * PŮVODNÍ add_overlay_div($content) – už nepotřebné.
     * Nechávám tu jen pro referenci, ale není volané.
     */

    /**
     * @param $content
     * @return string|void
     */
    public function prefix_insert_post_ads($content)
    {
        $args = [
            'post_type' => SEZNAM_SSP_POST_TYPE_SLUG,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_key' => 'sssp-zone-position',
            'meta_query' => [
                'relation' => 'OR',
                [
                    'key' => 'sssp-ad-active',
                    'value' => 'active',
                    'compare' => '=',
                ],
                [
                    'key' => 'sssp-ad-active',
                    'value' => 'indev',
                    'compare' => '=',
                ],
            ],
            'meta_value' => ['inarticle', 'wallpaper'],
        ];
        return self::render_inarticle_ads($args, $content);
    }

    /**
     * @param $insertion
     * @param $paragraph_id
     * @param $content
     * @param $repeat
     * @return string
     */
    public function prefix_insert_after_paragraph($insertion, $paragraph_id, $content, $repeat, $ad_id)
    {
        $content = str_replace("<p></p>", "", $content);
        $closing_p = '</p>';
        $paragraphs = explode($closing_p, $content);
        $paragraphs = array_filter($paragraphs); //remove empty '' strings

        $paragraph_id_orig = $paragraph_id;

        $paragraph_repeat_start = $paragraph_id + 3;

        if ($this->check_the_last_paragraph($paragraphs)) {
            $paragraphs_count_total = count($paragraphs);
        } else {
            $paragraphs_count_total = count($paragraphs) - 1;
        }

        $paragraphs_count = $paragraphs_count_total - $paragraph_id;

        if ($paragraph_id + 2 < $paragraphs_count_total) {
            foreach ($paragraphs as $index => $paragraph) {
                if (trim($paragraph)) {
                    $paragraphs[$index] .= $closing_p;
                }

                if ($paragraph_id == $index + 1) {
                    $paragraphs[$index] .= $insertion;
                }

                if ('yes' == $repeat && $paragraphs_count >= 7) {
                    if ($paragraph_repeat_start == $index + 3 - $paragraph_id) {
                        $paragraphs[$paragraph_repeat_start] .= $insertion;

                        $paragraph_repeat_start = $paragraph_repeat_start + 4;
                        $paragraphs_count = $paragraphs_count - 4;
                    }
                }
            }
        } else {
            return $content;
        }

        $paragraphs = implode('', $paragraphs);

        if (is_numeric($paragraph_id_orig) && empty($paragraph_id_orig)) {
            $paragraphs = $insertion . $paragraphs;
        }

        return $paragraphs;
    }

    /**
     * @param $args
     * @return string
     */
    private function render_ads($args)
    {
        $ads = get_posts($args);

        $html = '';
        foreach ($ads as $ad) {
            $html .= do_shortcode('[seznam-ads id="' . $ad->ID . '" automatic="true"]');
        }
        return $html;
    }


    /**
     * aram $args
     * @return string|void
     */
    private function render_inarticle_ads($args, $content)
    {
        $ads = get_posts($args);

        if (!$ads) {
            return $content;
        }

        // First, render wallpapers, as it has precedence over in-article.
        foreach ($ads as $ad) {
            $ad_meta = SSSP_Main::get_ad_meta($ad->ID);

            if ($ad_meta['sssp-zone-position'] === 'wallpaper') {
                $ad_meta['sssp-zone-inarticle-placement'] = 1;

                if (
                    $ad_meta['sssp-ad-active'] == 'active' ||
                    $ad_meta['sssp-ad-active'] == 'indev' && current_user_can(SEZNAM_SSP_CAPABILITY)
                ) {
                    $content = self::prefix_insert_after_paragraph(
                        '[seznam-ads id="' . $ad->ID . '" automatic="true"]',
                        $ad_meta['sssp-zone-inarticle-placement'],
                        $content,
                        'no',
                        $ad->ID
                    );
                }
            }
        }

        // Then render in-article ads, skipping wallpapers.
        foreach ($ads as $ad) {
            $ad_meta = SSSP_Main::get_ad_meta($ad->ID);

            if ($ad_meta['sssp-zone-position'] === 'wallpaper') {
                continue;
            }

            if (!isset($ad_meta['sssp-zone-inarticle-placement'])) {
                $ad_meta['sssp-zone-inarticle-placement'] = get_post_meta($ad->ID, 'sssp-zone-inarticle-placement', true);
            }
            if (!isset($ad_meta['sssp-zone-inarticle-placement-repeat'])) {
                $ad_meta['sssp-zone-inarticle-placement-repeat'] = get_post_meta($ad->ID, 'sssp-zone-inarticle-placement-repeat', true);
            }

            if (
                $ad_meta['sssp-ad-active'] == 'active' ||
                $ad_meta['sssp-ad-active'] == 'indev' && current_user_can(SEZNAM_SSP_CAPABILITY)
            ) {
                $content = self::prefix_insert_after_paragraph(
                    '[seznam-ads id="' . $ad->ID . '" automatic="true"]',
                    $ad_meta['sssp-zone-inarticle-placement'],
                    $content,
                    $ad_meta['sssp-zone-inarticle-placement-repeat'],
                    $ad->ID
                );
            }
        }
        return $content;
    }


    /**
     * @param $paragraphs
     * @return bool
     */
    private function check_the_last_paragraph($paragraphs)
    {
        $last_paragraph = end($paragraphs);
        $pos = strpos($last_paragraph, '</p>');

        if ($pos === false) {
            return false;
        }

        return true;
    }
}
