jQuery(function ($) {
    'use strict';

    //Control form on document ready
    jQuery(document).ready(function () {
        sznl_check_redirect_target()
        sznl_check_capability_option();
        check_client_id_secret_field();
    });


    jQuery('#sznl-allowed-capability').change(function () {
        sznl_check_capability_option();
    });

    jQuery('#sznl-allowed-capability-special').change(function () {
        sznl_set_spec_capability_value();
    });

    jQuery('#sznl-redirect-target').change(function () {
        sznl_check_redirect_target();
    });


    /**
     * Check redirect status
     */
    function sznl_check_redirect_target(){
        if (jQuery('#sznl-redirect-target').find('option').eq(1).is(':selected')) {
            sznl_enable_element(['sznl-redirect-target-url']);
        } else {
            sznl_disable_element(['sznl-redirect-target-url']);
        }
    }

    /**
     * Check capability option
     */
    function sznl_check_capability_option() {

        if (jQuery('#sznl-allowed-capability').find('option').eq(3).is(':selected')) {
            sznl_enable_element(['sznl-allowed-capability-special']);
        } else {
            sznl_disable_element(['sznl-allowed-capability-special']);
        }
    }

    /**
     * Always synchronize selected special capability with value on the option in limit access option.
     */
    function sznl_set_spec_capability_value() {
        let new_value = jQuery('#sznl-allowed-capability-special').val();
        jQuery('#sznl-allowed-capability').find('option').eq(3).val(new_value);
    }

    /**
     * Disable elements if necessary - Input array
     * @param elements
     */
    function sznl_disable_element(elements) {
        jQuery.each(elements, function (index, value) {
            jQuery('#' + value).prop('disabled', 'disabled');
        })
    }

    /**
     * Enable elements if necessary - Input array
     * @param elements
     */
    function sznl_enable_element(elements) {
        jQuery.each(elements, function (index, value) {
            jQuery('#' + value).prop('disabled', false);
        })
    }


});

