<?php


class SZNL_LoginAdminMenu
{
    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;

    /**
     * Constructor
     *
     * @since     1.0.0
     */

    public function __construct()
    {
        add_action('admin_menu', [$this, 'add_menu_page']);
    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     * @since     1.0.0
     *
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (null == self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    /**
     *
     */
    public function add_menu_page()
    {
        if (current_user_can(SZNL_CAPABILITY)):

            add_menu_page(esc_attr__('Seznam Tools',
                SZNL_SLUG),
                esc_attr__('Seznam Tools', SZNL_SLUG),
                SZNL_CAPABILITY,
                'seznam-settings-page',
                [$this, 'sznl_settings_page']);
            add_submenu_page('seznam-settings-page',
                esc_attr__('General settings', SZNL_SLUG),
                esc_attr__('General settings', SZNL_SLUG),
                SZNL_CAPABILITY,
                'seznam-settings-page');
            add_submenu_page('seznam-settings-page',
                esc_attr__('Seznam login', SZNL_SLUG),
                esc_attr__('Seznam login', SZNL_SLUG),
                SZNL_CAPABILITY,
                'seznam-login-admin',
                [$this, 'sznl_login_admin_page']);

        endif;

    }

    /**
     *
     */
    public function sznl_settings_page()
    {
        if (isset($_GET['page']) && $_GET['page'] == 'seznam-settings-page') {
            require_once(SZNL_PATH . 'includes/settings/class-settings-admin-page.php');
            SZNL_AdminPageSettings::display_admin_page();
        }
    }

    /**
     *
     */
    public function sznl_login_admin_page()
    {
        if (isset($_GET['page']) && $_GET['page'] == 'seznam-login-admin') {
            require_once(SZNL_PATH . 'includes/login/class-login-admin-page.php');
            SZNL_AdminPageLogin::display_admin_page();
        }
    }


}