<?php


class SZNL_LoginAdmin
{
    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;

    /**
     * Constructor
     *
     * @since     1.0.0
     */

    public function __construct()
    {

        // Add styles
        if (SZNL_LoginAdmin::check_admin()) {
            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_styles']);
            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_scripts']);
        }

    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     * @since     1.0.0
     *
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (null == self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    /**
     * Register and enqueue admin-specific style sheet.
     */
    public function enqueue_admin_styles()
    {
        wp_enqueue_style(SZNL_SLUG . '-style', SZNL_URL . 'assets/css/admin.css', [], SZNL_VERSION);
        wp_enqueue_style(SZNL_SLUG . '-public-style', SZNL_URL . 'assets/css/public.css', [], SZNL_VERSION);

    }

    /**
     *
     */
    public function enqueue_admin_scripts()
    {
        wp_enqueue_script(SZNL_SLUG . '-admin-js', SZNL_URL . 'assets/js/admin.js', ['jquery'], SZNL_VERSION);

    }

    /**
     * @return bool
     */
    public static function check_admin()
    {

        if (isset($_GET['page']) && $_GET['page'] == 'seznam-settings-page') {
            return true;
        }
        if (isset($_GET['page']) && $_GET['page'] == 'seznam-login-admin') {
            return true;
        }
        if (isset($_POST['sznl-admin-save'])) {
            return true;
        }

        return false;
    }
}