<?php

if (!defined('WPINC')) {
    wp_die();
}

class SZNL_AdminPageLogin
{

    /**
     * Constructor
     *
     * @since     1.0.0
     */
    public function __construct()
    {

        require_once(SZNL_PATH . 'shortcodes/class-login-button-shortcode.php');
        //$this->shortcode = new SZNL_Shortcode_Login;
        add_action('plugins_loaded', ['SZNL_Shortcode_Login', 'get_instance']);
    }

    /**
     *
     */
    public static function display_admin_page()
    {
        if (isset($_POST['sznl-admin-save']) || isset($_POST['sznl-branding-save']) || isset($_POST['sznl-popup-save'])) {
            self::save_admin_page();
        }

        add_thickbox();

        $html = '<div class="wrap sznl-post-table sznl-block" style="max-width: 1600px">';
        $html .= '<h1>' . esc_attr__('Seznam login', SZNL_SLUG) . '</h1>';
        $html .= '<div class="sznl-post-table">';


        $html .= '<div class="sznl-post-table-left">';

        if (!SZNL_LoginFunctions::check_client_id_secret()) {
            $html .= '<div class="sznl-settings-box">';

            $html .= '<h2>' . html_entity_decode(sprintf(esc_html__('It is necessary to complete <a href="%s">General Settings</a> and fill in “Client ID” and “Client Secret” first!', SZNL_SLUG), admin_url('admin.php?page=seznam-settings-page'))) . '</h2>';

            $html .= '</div>';// sznl-settings-box
        }

        if (SZNL_LoginFunctions::check_client_id_secret()) {
            $html .= '<div class="sznl-settings-box">';

            $html .= '<form method="post" action="" class="sznl-form">';

            $html .= self::button_settings();
            $html .= self::save_button_block();

            $html .= '</form>';// sznl-form
            $html .= '</div>';// sznl-settings-box

            $html .= '<div class="sznl-settings-box">';

            $html .= self:: block_buttons();

            $html .= '</div>';// sznl-settings-box


            $html .= '</div>';// sznl-post-table-left


            $html .= '<div class="sznl-post-table-right">';

            $html .= self::block_help();

            $html .= '</div>';// sznl-post-table-right


            $html .= '</div>';// sznl-post-table
            $html .= '</div>';// wrap
        }

        echo $html;
    }

    /**
     * @return string
     */
    private static function button_settings()
    {
        $html = '<div id="sznl-button-window">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('WordPress login form Settings', SZNL_SLUG) . '</h2></div>';


        $html .= '<div class="sznl-width-50" style="vertical-align: bottom">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'checkbox',
            'name' => 'sznl-allow-button-form',
            'label' => esc_attr__('Allow “Log In with Seznam” button in WP login form', SZNL_SLUG) . '',
            'value' => get_option('sznl-allow-button-form', '0'),
            'required' => '',
        ]);

        $html .= '</div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'select',
            'name' => 'sznl-allow-button-form-template',
            'label' => esc_attr__('Select a template for the button in the WordPress login form', SZNL_SLUG) . '',
            'options' => array_flip(self::button_array()),
            'value' => get_option('sznl-allow-button-form-template', 'default-1'),
            'required' => '',
            'status' => '',
            'default' => 'center',
        ]);
        $html .= '</div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'select',
            'name' => 'sznl-redirect-target',
            'label' => esc_attr__('After login, redirect to', SZNL_SLUG) . '',
            'options' => [
                'home_page' => esc_attr__('Homepage', SZNL_SLUG),
                'to_specific_url' => esc_attr__('Specific URL', SZNL_SLUG),
            ],
            'value' => get_option('sznl-redirect-target', 'home_page'),
            'required' => '',
            'status' => '',
            'default' => 'center',
        ]);
        $html .= '</div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'text',
            'name' => 'sznl-redirect-target-url',
            'label' => esc_attr__('Redirect URL', SZNL_SLUG) . '',
            'value' => get_option('sznl-redirect-target-url', ''),
            'required' => 'required',
            'status' => 'disabled',
        ]);
        $html .= '</div>';


        $html .= SZNL_FormElements::get_form_field([
            'type' => 'hidden',
            'name' => 'sznl-login-form-save',
            'value' => '',
            'default' => esc_attr__('sznl-login-form-save', SZNL_SLUG),
        ]);


        $html .= '</div>'; //sznl-button-window


        return $html;

    }

    /**
     * @return string
     */
    private static function save_button_block()
    {

        $html = '<div class="sznl-clear"></div>';

        $html .= '<div class="sznl-width-100">';
        $html .= '<div class="sznl-form-button-box">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'submit',
            'name' => 'sznl-admin-save',
            'label' => esc_attr__('Save OAuth settings', SZNL_SLUG),
        ]);
        $html .= '</div>';// sznl-form-button-box
        $html .= '</div>';

        return $html;
    }


    /**
     * @return string
     */
    private static function block_help()
    {
        $html = '<div class="sznl-settings-box">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('Help', SZNL_SLUG) . '</h2></div>';

        $html .= '<div class="sznl-help-loginform sznl-help">' . self::loginform_settings_help() . '</div>';

        $html .= '</div>';// sznl-settings-box

        return $html;

    }


    /**
     * @return string
     */
    private static function block_buttons()
    {

        $html = '<div class="sznl-section-title"><h2>' . esc_attr__('Login Buttons', SZNL_SLUG) . '</h2></div>';

        $html .= '<p>' . esc_attr__('The default login button can have these basic color variants', SZNL_SLUG) . ':</p>';

        $buttons_array = self::button_array();

        $html .= '<div class="sznl-width-25 sznl-mobile-hide" style="vertical-align: top">';
        $html .= '<div class="sznl-help-capability sznl-help-headline">' . esc_attr__('Preview', SZNL_SLUG) . '</div>';
        $html .= '</div>';

        $html .= '<div class="sznl-width-25 sznl-mobile-hide" style="vertical-align: top">';
        $html .= '<div class="sznl-help-capability sznl-help-headline">' . esc_attr__('Shortcode', SZNL_SLUG) . '</div>';
        $html .= '</div>';

        $html .= '<div class="sznl-width-50 sznl-mobile-hide" style="vertical-align: top">';
        $html .= '<div class="sznl-help-capability sznl-help-headline">' . esc_attr__('PHP code', SZNL_SLUG) . '</div>';
        $html .= '</div>';

        foreach ($buttons_array as $button_key => $button_value) {

            $html .= '<div class="sznl-width-25" style="vertical-align: top">';
            $html .= '<div class="sznl-help-capability sznl-help">' . do_shortcode('[seznam-login template="' . $button_value . '"]') . '</div>';
            $html .= '</div>';

            $html .= '<div class="sznl-width-25" style="vertical-align: middle;">';
            $html .= '<div class="sznl-help-capability sznl-help">[seznam-login template="' . $button_value . '"]</div>';
            $html .= '</div>';

            $html .= '<div class="sznl-width-50" style="vertical-align: middle;">';
            $html .= '<div class="sznl-help-capability sznl-help">&lt;?php echo do_shortcode(\'[seznam-login template=&quot;' . $button_value . '&quot;]\'); ?&gt;</div>';
            $html .= '</div>';
        }

        return $html;

    }


    /**
     * @return string
     */
    private static function loginform_settings_help()
    {
        $html = '<h4>' . esc_attr__('WordPress login form Settings', SZNL_SLUG) . '</h4>';
        $format = html_entity_decode(sprintf(esc_attr__('WordPress has a standard login/registration form on the URL <a target="_blank" href="%s">%s</a>. You can easily add a “Log In with Seznam” button there. You can also pick the button color variant you want to use and the URL for redirecting after the login.', SZNL_SLUG), home_url() . '/wp-login.php', home_url() . '/wp-login.php'));
        $html .= $format;
        return $html;
    }


    /**
     * @return string
     */
    private static function block_requirements()
    {

        $html = '<div class="sznl-system-check-row"><span>' . esc_attr__('WordPress version', SZNL_SLUG) . ':</span> 5.2 +</div>';
        $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('PHP version', SZNL_SLUG) . ':</span> 5.6 +</div>';
        return $html;

    }

    /**
     * @return bool[]
     */
    private static function create_capabilities_array()
    {
        $capabilities = get_role('administrator')->capabilities;

        unset($capabilities['manage_options']);
        unset($capabilities['edit_pages']);
        unset($capabilities['edit_posts']);
        foreach ($capabilities as $key => $value) {
            $capabilities[$key] = $key;
        }

        return $capabilities;
    }


    /**
     *
     */
    public static function save_admin_page()
    {
        if (current_user_can(SZNL_CAPABILITY)) {
            $_SANITIZED_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            //Save checkbox "allow seznam login button"
            if (isset($_POST['sznl-login-form-save'])) {
                unset($_SANITIZED_POST['sznl-login-form-save']);
                if (isset($_SANITIZED_POST['sznl-allow-button-form'])) {
                    $_SANITIZED_POST['sznl-allow-button-form'] = '1';
                } else {
                    $_SANITIZED_POST['sznl-allow-button-form'] = '0';
                }
            }

            foreach ($_SANITIZED_POST as $post_key => $post_value) {
                update_option($post_key, $post_value, true);
            }
        }
    }

    /**
     * @return string[]
     */
    private static function button_array()
    {
        return [
            esc_attr__('Red & White', SZNL_SLUG) => 'default-1',
            esc_attr__('Black & White', SZNL_SLUG) => 'default-2',
            esc_attr__('White & Red', SZNL_SLUG) => 'default-3',
            esc_attr__('White & Black', SZNL_SLUG) => 'default-4',
            esc_attr__('White & Red with border', SZNL_SLUG) => 'default-5',
            esc_attr__('White & Black with border', SZNL_SLUG) => 'default-6',
        ];
    }

}