<?php

if (!defined('WPINC')) {
    wp_die();
}

class SZNL_LoginFunctions
{

    /**
     * @var null
     */
    protected static $instance = NULL;

    /**
     * Constructor
     *
     * @since     1.0.0
     */
    public function __construct()
    {
        add_action('login_form', [$this, 'add_button_to_loginform']);
        add_action('login_enqueue_scripts', [$this, 'add_scripts_to_loginform']);
    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     * @since     1.0.0
     *
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (NULL == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     *
     */
    public function add_scripts_to_loginform()
    {
        wp_enqueue_style(SZNL_SLUG . '-public-style', SZNL_URL . 'assets/css/public.min.css', [], SZNL_VERSION);
        wp_enqueue_script(SZNL_SLUG . '-loginform', SZNL_URL . 'assets/js/loginform.min.js', ['jquery'], SZNL_VERSION, false);
    }

    /**
     *
     */
    public function add_button_to_loginform()
    {
        if (!SZNL_LoginFunctions::check_client_id_secret() or is_user_logged_in()) {
            return;
        }

        $allow_loginform_button = get_option('sznl-allow-button-form', 0);
        if ($allow_loginform_button != 1) {
            return;
        }
        $button_template = get_option('sznl-allow-button-form-template', 'default-1');

        $html = '<div class="sznl-button-box" style="display: none">';
        $html .= '<div class="sznl-text-divider">' . esc_attr__('Or', SZNL_SLUG) . '</div>';
        if (isset($_GET['sznl_error']) && $_GET['sznl_error'] == 'true') {
            $html .= '<div class="sznl-text-error">' . esc_attr__('Something went wrong. Please try logging in again!', SZNL_SLUG) . '</div>';
        } else if (isset($_GET['sznl_error']) && $_GET['sznl_error'] == 'register-not-allowed') {
            $html .= '<div class="sznl-text-error">' . esc_attr__('New registration on this site is not allowed, you can only log in to an existing account!', SZNL_SLUG) . '</div>';
        }
        $html .= do_shortcode('[seznam-login template="' . $button_template . '"]');
        $html .= '</div>';

        echo $html;
    }

    /**
     * @return bool
     */
    public static function check_client_id_secret()
    {
        if (!get_option('sznl-oauth-client-id')) {
            return false;
        }
        if (!get_option('sznl-oauth-client-secret')) {
            return false;
        }

        return true;
    }
}
