<?php

if (!defined('WPINC')) {
    wp_die();
}

class SZNL_AdminPageSettings
{

    /**
     * Constructor
     *
     * @since     1.0.0
     */
    public function __construct()
    {

        require_once(SZNL_PATH . 'shortcodes/class-login-button-shortcode.php');
        //$this->shortcode = new SZNL_Shortcode_Login;
        add_action('plugins_loaded', ['SZNL_Shortcode_Login', 'get_instance']);
    }

    /**
     *
     */
    public static function display_admin_page()
    {
        if (isset($_POST['sznl-admin-settings-save'])) {
            self::save_admin_page();
        }

        add_thickbox();

        $html = '<div class="wrap sznl-post-table sznl-block" style="max-width: 1600px">';
        $html .= '<h1>' . esc_attr__('Seznam Tools WP General settings', SZNL_SLUG) . '</h1>';
        $html .= '<div class="sznl-post-table">';


        $html .= '<div class="sznl-post-table-left">';

        $html .= '<div class="sznl-settings-box">';

        $html .= '<form method="post" action="" class="sznl-form">';

        $html .= self::block_settings();
        $html .= self::oauth_settings();
        $html .= self::save_button_block();

        $html .= '</form>';// sznl-form
        $html .= '</div>';// sznl-settings-box


        $html .= self::create_oauth_help();


        $html .= '</div>';// sznl-post-table-left


        $html .= '<div class="sznl-post-table-right">';

        $html .= self::block_help();

        $html .= '</div>';// sznl-post-table-right


        $html .= '</div>';// sznl-post-table
        $html .= '</div>';// wrap

        echo $html;
    }

    /**
     * @return string
     */
    private static function block_settings()
    {

        $html = '<div class="sznl-section-title"><h2>' . esc_attr__('Security settings', SZNL_SLUG) . '</h2></div>';


        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'select',
            'name' => 'sznl-allowed-capability',
            'label' => esc_attr__('Restrict access to the plugin to', SZNL_SLUG) . '',
            'options' => [
                'manage_options' => esc_attr__('Administrators (capability: manage_options)', SZNL_SLUG),
                'edit_pages' => esc_attr__('Administrators, Editors (capability: edit_pages)', SZNL_SLUG),
                'edit_posts' => esc_attr__('Administrators, Editors, Authors (capability: edit_posts)', SZNL_SLUG),
                get_option('sznl-allowed-capability-special', 'publish_posts') => esc_attr__('Specific user capability', SZNL_SLUG),
            ],
            'value' => get_option('sznl-allowed-capability', 'edit_pages'),
            'required' => '',
            'status' => '',
            'default' => 'center',
        ]);
        $html .= '</div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'select',
            'name' => 'sznl-allowed-capability-special',
            'label' => esc_attr__('Select special capability', SZNL_SLUG),
            'options' => self::create_capabilities_array(),
            'value' => get_option('sznl-allowed-capability-special', 'publish_posts'),
            'required' => '',
            'status' => 'disabled',
            'default' => 'center',
        ]);
        $html .= '</div>';

        return $html;

    }

    /**
     * @return string
     */
    private static function oauth_settings()
    {

        $html = '<div class="sznl-section-title"><h2>' . esc_attr__('OAuth 2.0 settings', SZNL_SLUG) . '</h2></div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'text',
            'name' => 'sznl-oauth-client-id',
            'label' => esc_attr__('Client ID', SZNL_SLUG),
            'value' => get_option('sznl-oauth-client-id', ''),
            'required' => 'required',
        ]);
        $html .= '</div>';

        $html .= '<div class="sznl-width-50">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'text',
            'name' => 'sznl-oauth-client-secret',
            'label' => esc_attr__('Client Secret', SZNL_SLUG),
            'value' => get_option('sznl-oauth-client-secret', ''),
            'required' => 'required',
        ]);
        $html .= '</div>';

        return $html;

    }


    /**
     * @return string
     */
    private static function save_button_block()
    {

        $html = '<div class="sznl-clear"></div>';

        $html .= '<div class="sznl-width-100">';
        $html .= '<div class="sznl-form-button-box">';
        $html .= SZNL_FormElements::get_form_field([
            'type' => 'submit',
            'name' => 'sznl-admin-settings-save',
            'label' => esc_attr__('Save general settings', SZNL_SLUG),
        ]);
        $html .= '</div>';// sznl-form-button-box
        $html .= '</div>';

        return $html;
    }


    /**
     * @return string
     */
    private static function block_help()
    {
        $html = '<div class="sznl-settings-box">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('Help', SZNL_SLUG) . '</h2></div>';

        $html .= '<div class="sznl-help-capability sznl-help">' . self::capability_filter_help() . '</div>';
        $html .= '<div class="sznl-help-oauth sznl-help">' . self::oauth_settings_help() . '</div>';

        $html .= '</div>';// sznl-settings-box


        $html .= '<div class="sznl-settings-box">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('System requirements', SZNL_SLUG) . '</h2></div>';
        $html .= self::block_requirements();
        $html .= '</div>';// sznl-settings-box

        $html .= '<div class="sznl-settings-box">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('System info', SZNL_SLUG) . '</h2></div>';
        $html .= self::block_checker();
        $html .= '</div>';// sznl-settings-box

        return $html;

    }

    private static function create_oauth_help(){
        $html = '<div class="sznl-settings-box" id="sznl-preview-box">';
        $html .= '<div class="sznl-section-title"><h2>' . esc_attr__('How to get “Client ID” and “Client Secret”', SZNL_SLUG) . '</h2></div>';
        $html .= '<div class="sznl-image-preview-box-text">';
        $html .= '<ul>';
        $html .= '<li>' . html_entity_decode(sprintf(esc_html__('<strong>The first step:</strong> Visit the Seznam.cz developers page <a href="%s">https://vyvojari.seznam.cz/oauth/admin</a> and log in to your standard Seznam Account.', SZNL_SLUG), 'https://vyvojari.seznam.cz/oauth/admin')) . '</li>';
        $html .= '<li><img src="' . SZNL_URL . 'assets/images/oauth1.png" alt="" title=""></li>';
        $html .= '<li><br>' . html_entity_decode(esc_attr__('<strong>The second step:</strong> Click “Add another service” button.', SZNL_SLUG)) . '</li>';
        $html .= '<li><img src="' . SZNL_URL . 'assets/images/oauth2.png" alt="" title=""></li>';
        $html .= '<li><br>' . html_entity_decode(esc_attr__('<strong>The third step:</strong> In this step, you create a service for user login. In the first form field, give your service a name. This name will also be visible to your users during the login procedure. In the second field, specify all possible URLs of your website. Each URL must be on a separate line (see the image below). The third field is an icon representing your site. Be sure the icon is square and has at least 64 × 64 pixels. The format of the icon should be jpeg, jpg, gif, or png. In the last form field, fill in the URL of your privacy policy page.', SZNL_SLUG)) . '</li>';
        $html .= '<li><img src="' . SZNL_URL . 'assets/images/oauth3.png" alt="" title=""></li>';
        $html .= '<li><br>' . html_entity_decode(esc_attr__('<strong>The fourth step:</strong> Before adding a service, make sure you have checked the terms and conditions approval box. You can then continue by clicking the “Add new service” button.', SZNL_SLUG)) . '</li>';
        $html .= '<li><img src="' . SZNL_URL . 'assets/images/oauth4.png" alt="" title=""></li>';
        $html .= '<li><br>' . html_entity_decode(esc_attr__('<strong>The last step:</strong> You have created the service and can copy your “Client ID” and “Client Secret”. Fill these values in at the top of this page. Then don’t forget to save the settings.', SZNL_SLUG)) . '</li>';
        $html .= '<li><img src="' . SZNL_URL . 'assets/images/oauth5.png" alt="" title=""></li>';
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';// sznl-settings-box

        return $html;
    }



    /**
     * @return string
     */
    private static function capability_filter_help()
    {
        $html = '<h4>' . esc_attr__('Restrict access to the plugin to', SZNL_SLUG) . '</h4>';
        $format = html_entity_decode(esc_attr__('You have the option to restrict access to the plugin interface. Selecting “Specific user capability” gives you more flexibility in choosing who can access the plugin but can make it accessible to the wrong people. Therefore, only a small group of experienced users should manage this setting.', SZNL_SLUG));
        $html .= $format;
        return $html;
    }

    /**
     * @return string
     */
    private static function oauth_settings_help()
    {
        $html = '<h4>' . esc_attr__('OAuth 2.0 settings', SZNL_SLUG) . '</h4>';
        $format = html_entity_decode(sprintf(esc_attr__('If you want to start using Seznam Login, you must first create a service on the <a target="_blank" href="%s">Seznam Developers page</a> where you get “Client ID” and “Client Secret”. Entering this information is mandatory.', SZNL_SLUG), 'https://vyvojari.seznam.cz/oauth/admin'));
        $html .= $format;
        return $html;
    }


    /**
     * @return string
     */
    private static function block_requirements()
    {

        $html = '<div class="sznl-system-check-row"><span>' . esc_attr__('WordPress version', SZNL_SLUG) . ':</span> 5.2 +</div>';
        $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('PHP version', SZNL_SLUG) . ':</span> 5.6 +</div>';
        return $html;

    }

    /**
     * @return string
     */
    private static function block_checker()
    {
        global $wp_version;
        $html = null;

        $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('WordPress version', SZNL_SLUG) . ':</span> ' . $wp_version . '</div>';
        $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('Current PHP version', SZNL_SLUG) . ':</span> ' . phpversion() . '</div>';
        $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('Seznam Tools WP version', SZNL_SLUG) . ':</span> ' . SZNL_VERSION . '</div>';

        if (in_array('curl', get_loaded_extensions())) {
            $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('Curl installed', SZNL_SLUG) . ':</span> <strong style="color:darkgreen;">' . esc_attr__('Yes', SZNL_SLUG) . '</strong></div>';
        } else {
            $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('Curl installed', SZNL_SLUG) . ':</span> <strong style="color:darkred;">' . esc_attr__('No', SZNL_SLUG) . ' *</strong></div>';
            $html .= '<p style="color:darkred;">*' . esc_attr__('Curl, or cURL, is a library that allows you to connect to and communicate with many different types of servers. This library is necessary for the plugin to work correctly. Contact your server administrator or web hosting provider to request the installation of this library.', SZNL_SLUG) . '</p>';
        }

        if (self::is_ssl()) {
            $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('SSL Certificate', SZNL_SLUG) . ':</span> <strong style="color:darkgreen;">' . esc_attr__('Yes', SZNL_SLUG) . '</strong></div>';
        } else {
            $html .= '<div class="sznl-system-check-row"><span>' . esc_attr__('SSL Certificate', SZNL_SLUG) . ':</span> <strong style="color:darkred;">' . esc_attr__('No', SZNL_SLUG) . ' **</strong></div>';
            $html .= '<p style="color:darkred;">**' . esc_attr__('SSL is a cryptographic protocol designed to ensure communication security on a computer network. The protocol is widely used in applications like e-mail, instant messaging, and VoIP, but its use in HTTPS security remains the most visible. SSL is mandatory for the Seznam Login service. Contact your server administrator or web hosting provider to request SSL certification.', SZNL_SLUG) . '</p>';
        }

        $html .= '<div class="sznl-clear"></div>';
        return $html;

    }

    /**
     * @return bool[]
     */
    private static function create_capabilities_array()
    {
        $capabilities = get_role('administrator')->capabilities;

        unset($capabilities['manage_options']);
        unset($capabilities['edit_pages']);
        unset($capabilities['edit_posts']);
        foreach ($capabilities as $key => $value) {
            $capabilities[$key] = $key;
        }

        return $capabilities;
    }


    /**
     *
     */
    public static function save_admin_page()
    {
        if (current_user_can(SZNL_CAPABILITY)) {
            $_SANITIZED_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            //Save checkbox "allow seznam login button"
            if (isset($_POST['sznl-login-form-save'])) {
                unset($_SANITIZED_POST['sznl-login-form-save']);
                if (isset($_SANITIZED_POST['sznl-allow-button-form'])) {
                    $_SANITIZED_POST['sznl-allow-button-form'] = '1';
                } else {
                    $_SANITIZED_POST['sznl-allow-button-form'] = '0';
                }
            }

            foreach ($_SANITIZED_POST as $post_key => $post_value) {
                update_option($post_key, $post_value, true);
            }
        }

    }

    /**
     * @return bool
     */
    private static function is_ssl() {
        if ( isset($_SERVER['HTTPS']) ) {
            if ( 'on' == strtolower($_SERVER['HTTPS']) )
                return true;
            if ( '1' == $_SERVER['HTTPS'] )
                return true;
        } elseif ( isset($_SERVER['SERVER_PORT']) && ( '443' == $_SERVER['SERVER_PORT'] ) ) {
            return true;
        }
        return false;
    }

}