<?php

/**
 *
 * @package   Seznam Nástroje WP
 * @author    Zbynek Hovorka [Seznam.cz, a.s.]
 * @co-author Jan Lokvenc [Seznam.cz, a.s.]
 * @link      https://partner.seznam.cz/
 * @copyright 2022+ Seznam.cz
 *
 * @wordpress-plugin
 * Plugin Name:       Seznam Nástroje WP
 * Plugin URI:        https://partner.seznam.cz/seznam-nastroje-wp
 * Description:       Plugin pro snadnou integraci a využití aplikací spojených se službou Přihlášení přes Seznam.
 * Version:           1.2
 * Author:            Seznam.cz, a.s.
 * Author URI:        https://partner.seznam.cz/
 * Text Domain:       seznam-wp-tools
 */

// If this file is called directly, abort.

if (!defined('WPINC')) {
    wp_die();
}

//Define basic constants
define('SZNL_PATH', plugin_dir_path(__FILE__));
define('SZNL_URL', plugin_dir_url(__FILE__));
define('SZNL_ADMIN_URL', admin_url());
define('SZNL_DATE_FORMAT', get_option('date_format'));
define('SZNL_TIME_FORMAT', get_option('time_format'));
define('SZNL_SLUG', 'seznam-wp-tools');
define('SZNL_CAPABILITY', get_option('sznl-allowed-capability', 'edit_pages'));
define('SZNL_VERSION', '1.2');
define('SZNL_WIDGET_SLUG', 'sznl_widget');
define('SZNL_UPDATE_JSON', base64_decode('aHR0cHM6Ly9wYXJ0bmVyLnNlem5hbS5jei93cC1jb250ZW50L3VwbG9hZHMvc2V6bmFtLXVwZGF0ZXIuanNvbg=='));



if (is_admin()) {
    //Include class for admin
    require_once(SZNL_PATH . 'includes/class-sznt-admin.php');
    add_action('plugins_loaded', ['SZNL_LoginAdmin', 'get_instance']); //Admin Class
    //Include class for admin
    require_once(SZNL_PATH . 'includes/class-sznt-admin-menu.php');
    add_action('plugins_loaded', ['SZNL_LoginAdminMenu', 'get_instance']); //Admin Menu Class
    require_once(SZNL_PATH . 'includes/class-sznt-form-elements.php');
}

if (!is_admin() || SZNL_LoginAdmin::check_admin()) {
    require_once(SZNL_PATH . 'shortcodes/class-login-button-shortcode.php');
    //Load frontend classes
    add_action('plugins_loaded', ['SZNL_Shortcode_Login', 'get_instance']); //Main Class
}


//Include class for login
require_once(SZNL_PATH . 'includes/class-sznt.php');
add_action('plugins_loaded', ['SZNL_LoginMain', 'get_instance']); //Main Class

//Include login functions
require_once(SZNL_PATH . 'includes/login/class-login-functions.php');
add_action('plugins_loaded', ['SZNL_LoginFunctions', 'get_instance']); //Main Class

//Include Oauth functions
require_once(SZNL_PATH . 'includes/class-sznt-oauth.php');
add_action('plugins_loaded', ['SZNL_OauthAuthenticator', 'get_instance']); //Main Class

//Check updates
if (is_admin() || defined( 'DOING_CRON' ) && DOING_CRON ) {
    include_once(SZNL_PATH . 'includes/plugin-updates/class-sznt-plugin-updates.php');
    new SZNL_PluginUpdates();
}
