<?php

if (!defined('WPINC')) {
    wp_die();
}

class SZNL_Shortcode_Login
{
    protected static $instance = NULL;

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    public function __construct()
    {
        //Create Image Gallery Custom Post
        add_shortcode('seznam-login', [$this, 'shortcode']);

    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     * @since     1.0.0
     *
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (NULL == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     * @param $atts
     * @param null $content
     * @return string
     */
    public function shortcode($atts, $content = NULL)
    {

        if(!SZNL_LoginFunctions::check_client_id_secret()){
            return ;
        }
        if (isset($atts['template'])) {
            $type = 'sznl-button-template-' . $atts['template'];
        } else {
            return null;
        }

        $html = null;

        switch ($atts['template']) {
            case 'default-1' :
            case 'default-2' :
            case 'default-3' :
            case 'default-4' :
            case 'default-5' :
            case 'default-6' :
                $arguments = [
                    'type' => 'basic',
                    'template' => $atts['template'],
                    'text' => esc_attr__('Log In with Seznam', SZNL_SLUG),
                    'icon-size' => 16,
                    'icon-padding' => 16,
                    'corners' => 3,
                    'width' => 180,
                    'height' => 60,
                    'padding-icon' => 20,
                    'font size' => 14,
                    'redirect' => get_option('sznl-redirect-target', 'home_page'),
                    'redirect_uri' => get_option('sznl-redirect-target-url', home_url()),

                ];
                $html .= $this->create_button($arguments);
                break;
            default:
                // Here will be the code for custom templates.
                $html .= '<div class="sznl-button-template sznl-custom">';
                $html .= '2';
                $html .= '</div>';// sznl-button-template
                break;

        }

        return $html;

    }

    /**
     * @param $arguments
     */
    private function create_button($arguments)
    {

        require_once(SZNL_PATH . 'includes/class-sznt-oauth.php');
        $auth = new SZNL_OauthAuthenticator();
        if ($auth->getAuthorizationCode()){
            $url = "location.href='".$auth->getAuthorizationCode()."'";
        }else{
            return;
        }

        $colors = $this->get_button_colors($arguments['template']);

        $svg = '<svg width="31" height="33" viewBox="0 0 31 33" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M15.5941 1.76096C14.6991 1.90537 13.8112 2.07412 12.9267 2.26597C12.3415 2.39106 11.7568 2.50777 11.1787 2.65427C10.646 2.78986 10.099 2.90992 9.57681 3.077C9.07181 3.23736 8.57394 3.40275 8.07943 3.59418C7.11853 3.97031 6.20633 4.50302 5.41587 5.16797C4.93185 5.57726 4.47932 6.0214 4.09941 6.5348C3.83159 6.90211 3.60868 7.27992 3.39291 7.68208C3.19099 8.06325 3.05162 8.51452 3.04784 8.95152C3.04112 10.2365 3.85216 11.3124 4.78577 12.1113C5.09221 12.3724 5.41923 12.6129 5.75002 12.8425C6.73191 13.5251 7.80111 14.1242 8.88752 14.6464C10.0088 15.1824 11.1367 15.6979 12.279 16.1887C13.3583 16.6504 14.4623 17.0421 15.5764 17.4145C15.8967 17.5207 16.2208 17.6269 16.5411 17.7331C17.5507 18.071 18.5817 18.3829 19.5846 18.7481C20.2075 18.9748 20.8729 19.1872 21.4959 19.471C22.1436 19.7653 22.8157 20.0591 23.387 20.4823C23.7699 20.7606 24.1007 21.109 24.3441 21.515C24.5847 21.915 24.7341 22.3734 24.7446 22.8415C24.7589 23.2907 24.63 23.7277 24.3895 24.1076C23.7627 25.0924 22.673 25.7645 21.6214 26.212C20.051 26.8786 18.4423 27.455 16.8056 27.9394C15.8724 28.2144 14.9392 28.4872 13.9993 28.7332C13.0556 28.9801 12.0943 29.2399 11.1405 29.48C10.1897 29.7206 9.23888 29.9376 8.28512 30.145C7.73856 30.2617 7.18822 30.378 6.64501 30.4917C6.31757 30.5576 5.99728 30.6273 5.67026 30.6987C4.98768 30.8481 4.30511 30.9963 3.61917 31.1436C2.83921 31.3166 2.05882 31.4849 1.27927 31.6562C1.05258 31.7062 0.826319 31.767 0.600053 31.8178C0.398134 31.8644 -0.357485 32.0407 0.203352 32.0072C0.9829 31.9635 3.06547 31.7809 7.51565 31.1823C9.12764 30.9144 10.7468 30.6831 12.3625 30.4183C14.375 30.0879 16.374 29.6992 18.3584 29.2261C18.9263 29.0917 19.4901 28.9473 20.0543 28.7924C20.4271 28.6879 20.7961 28.58 21.1617 28.465C22.7217 27.9789 25.2253 27.1204 25.8172 26.8614C28.0807 25.8652 29.4907 25.1151 30.2258 23.3289C30.4764 22.695 30.5948 21.9847 30.518 21.3042C30.4416 20.6808 30.2325 20.0507 29.9089 19.5126C29.5986 18.9954 29.1738 18.5533 28.7318 18.1457C27.9065 17.3901 26.9804 16.7793 25.9914 16.2621C25.7131 16.1156 25.4272 15.9763 25.1384 15.844C24.7795 15.6791 24.421 15.5237 24.0587 15.3705C23.547 15.1564 23.0315 14.97 22.5092 14.7908C21.1512 14.3244 19.7722 13.9063 18.4075 13.4588C17.6342 13.2048 16.8685 12.9299 16.123 12.6129C15.8065 12.4803 15.4929 12.3375 15.1864 12.1881C14.8246 12.0122 14.4728 11.8191 14.1244 11.6117C13.6962 11.3523 12.9964 10.9048 13.1912 10.2974C13.3272 9.86372 13.7969 9.69497 14.1802 9.53965C14.5354 9.39524 14.9115 9.29407 15.2805 9.1971C16.4089 8.90618 17.5612 8.70972 18.6997 8.46541C19.0342 8.39404 19.3684 8.321 19.703 8.24292C20.5908 8.03386 21.5064 7.87686 22.3527 7.53935C23.0806 7.25222 24.0133 6.79255 24.2854 5.99159C24.6749 4.82332 24.2329 3.56101 23.5957 2.57577C23.366 2.22231 23.1293 1.87598 22.8854 1.52924C22.5512 1.05907 22.1818 0.617037 21.82 0.169542C21.6562 -0.0340553 21.4577 -0.0185231 21.2906 0.0335306C21.0677 0.110352 20.4586 0.826092 15.5941 1.76096Z" fill="' . $colors['font'] . '"/>
</svg>';

        $html = '<div class="sznl-button-template sznl-type-' . $arguments['type'] . ' sznl-template-' . $arguments['template'] . '" onclick='.$url.'>';
        $html .= '<div class="sznl-button" style="background-color:' . $colors['background'] . '; border: 2px solid ' . $colors['border'] . '; box-shadow: ' . $colors['box-shadow'] . '">';
        $html .= '<div class="sznl-button-icon">' . $svg . '</div>';
        $html .= '<div class="sznl-button-text" style="color:' . $colors['font'] . '">' . $arguments['text'] . '</div>';
        $html .= '</div>';// sznl-button
        $html .= '</div>';// sznl-button-template

        return $html;

    }

    /**
     * @param $type
     * @return string[]|void
     */
    private function get_button_colors($type)
    {

        switch ($type) {
            case 'default-1' :
                return [
                    'background' => '#CC0000',
                    'border' => '#CC0000',
                    'font' => '#ffffff',
                    'box-shadow' => 'none',

                ];
            case 'default-2' :
                return [
                    'background' => '#000000',
                    'border' => '#000000',
                    'font' => '#ffffff',
                    'box-shadow' => 'none',
                ];
            case 'default-3' :
                return [
                    'background' => '#ffffff',
                    'border' => '#ffffff',
                    'font' => '#CC0000',
                    'box-shadow' => '2px 2px 4px #cccccc',
                ];
            case 'default-4' :
                return [
                    'background' => '#ffffff',
                    'border' => '#ffffff',
                    'font' => '#000000',
                    'box-shadow' => '2px 2px 4px #cccccc',
                ];
            case 'default-5' :
                return [
                    'background' => '#ffffff',
                    'border' => '#CC0000',
                    'font' => '#CC0000',
                    'box-shadow' => 'none',
                ];
            case 'default-6' :
                return [
                    'background' => '#ffffff',
                    'border' => '#000000',
                    'font' => '#000000',
                    'box-shadow' => 'none',
                ];
        }
    }
}
